// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#define ADDRESS DWORD
#include "math.h"
#include <vector>
#include <set>
#include <map>
#include <fstream>
#include <iomanip>

//#define USER_CONTROL
//#define PRINT_DEBUG_INFO
#define PRINT_DECISIONS

inline void assert(bool b)
{
	if(b)
		return;
	printf("Assertion fehlgeschlagen!\n");
	while(true)
		;
	MessageBox(0, "Assertion fehlgeschlagen..", "Asteroids KI", 0);
}

template<typename T>
void assert(bool b, const T& Exc)
{
	if(!b)
		throw Exc;
}


class VRamInvalidException
{
};

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;
const int MaxInt = 0x7FFFFFFF;

//#pragma warning( disable: 4309)

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	void clear(void);
};

enum Direction
{
	Dir_Left,
	Dir_None,
	Dir_Right
};

#pragma pack(1)

class KeysPacket
{
private:
	char signature[6];
public:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char keys;
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void SwapDirection()
	{
		if(keys & KEY_LEFT)
		{
			assert((keys&KEY_RIGHT) == 0);
			left(false);
			right(true);
		}
		else if(keys&KEY_RIGHT)
		{
			assert((keys&KEY_LEFT) == 0);
			left(true);
			right(false);
		}
	}
	void FromDirection(Direction Dir)
	{
		left(Dir == Dir_Left);
		right(Dir == Dir_Right);
	}
};



const int cAsteroids = 27;
const int cPlayerShots = 4;
const int cSaucerShots = 2;

enum
{
	AsteroidMinIndex,
	AsteroidMaxIndex = AsteroidMinIndex+cAsteroids-1,
	PlayerIndex,
	SaucerIndex,
	SaucerShotMinIndex,
	SaucerShotMaxIndex = SaucerShotMinIndex+cSaucerShots-1,
	PlayerShotMinIndex,
	PlayerShotMaxIndex = PlayerShotMinIndex+cPlayerShots-1,
	NumObjects
};

const int ShotLifetime = 0x12 * 4;
const int RotationSpeed = 3;

inline word MoveLinearX(word PositionX, char VelocityX, int Steps)
{
	return (PositionX + VelocityX*Steps) & 0x1FFF;
/*	word oldPositionX = PositionX;
	for(int i = 0; i < Steps; i++)
	{
		PositionX += char(VelocityX);
		if(PositionX >= 0x2000)//Objekt geht rechts raus
		{
			PositionX &= 0x1FFF;//links wieder rein
		}
	}
	if(PositionX != ((oldPositionX+char(VelocityX)*Steps)&0x1FFF))
		assert(0);
	return PositionX;*/
}

inline word MoveLinearY(word PositionY, char VelocityY, int Steps)
{
	const word PositionYIn = PositionY;
	word oldPositionY = PositionY;

	PositionY += VelocityY;
	if((PositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		PositionY = 0x0000 | (PositionY & 0x00FF);
	else if(PositionY >= 0x1800)
		PositionY = 0x1700 | (PositionY & 0x00FF);

	PositionY += VelocityY*(Steps-1);
	if(VelocityY >= 0)
	{
		while(PositionY >= 0x1800)
			PositionY -= 0x1800;
	}
	else
		while(PositionY >= 0x1800)
			PositionY += 0x1800;
//	return PositionY;

	for(int i = 0; i < Steps; i++)
	{
		oldPositionY += VelocityY;
		if((oldPositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		{
			oldPositionY = 0x0000 | (oldPositionY&0x00FF);
		}
		else if(oldPositionY >= 0x1800)
		{
			oldPositionY = 0x1700 | (oldPositionY&0x00FF);
		}
	}
	if(PositionY != oldPositionY)
		assert(0);
	return PositionY;
}
struct ShotInfo
{
public:
	ShotInfo()
	{
		Time = MaxInt;
	}
public:
	int Time;
	Direction Dir;
	byte TargetDirection;
	int CollisionTime;
	bool RotationWasLocked;

	int ShotIndex;
	word PositionX, PositionY;
	int Target;
	word StartX, StartY;
	char VelocityX, VelocityY;
	word TargetPositionX, TargetPositionY;
	char TargetStatus;
};

extern bool updating;
extern __int64* pScore;
extern bool DecisionAdded;

inline word MakeWord(byte high, byte low)
{
	return word(high)<<8 | word(low);
}
inline void MakeBytesFromWord(word Word, byte& High, byte& Low)
{
	High = byte(Word>>8);
	Low = byte(Word);
}
inline byte& LowByte(word& Word)
{
	return (byte&)Word;
}
inline byte& HighByte(word& Word)
{
	return *(((byte*)&Word)+1);
}
inline byte Half(byte value)
{
	if(char(value) >= 0)
		return value/2;
	else
		return char(value-1)/2;
}
inline void Clamp(byte& value, byte min, byte max)
{
	if(char(value) >= 0)
	{
		if(value > max)
			value = max;
	}
	else
	{
		if(value < min)
			value = min;
	}
}
template<typename T>
T Min(T a, T b)
{
	return a<b ? a : b;
}
template<typename T>
T Max(T a, T b)
{
	return a>b ? a : b;
}
inline word DecimalToBin(byte High, byte Low)
{
	return (High>>4)*1000 + (High&0x0F)*100 + (Low>>4)*10 + (Low&0x0F);
}
inline void BinToDecimal(word Bin, byte& High, byte& Low)
{
	Low = Bin%10;
	Bin /= 10;
	Low |= Bin%10 << 4;
	Bin /= 10;
	High = Bin%10;
	Bin /= 10;
	High |= Bin%10 << 4;
}
inline byte& ShiftLeft(byte& byte, bool& carry)
{
	carry = (byte>>7) != 0;
	byte <<= 1;
	return byte;
}
inline byte& RotateLeft(byte& byte, bool& carry)
{
	bool newcarry = (byte>>7) != 0;
	byte <<= 1;
	if(carry) byte |= 1;
	carry = newcarry;
	return byte;
}
inline byte& ShiftRight(byte& byte, bool& carry)
{
	carry = (byte&1) != 0;
	byte >>= 1;
	return byte;
}
inline byte& RotateRight(byte& byte, bool& carry)
{
	bool newcarry = (byte&1) != 0;
	byte >>= 1;
	if(carry) byte |= 0x80;
	carry = newcarry;
	return byte;
}
inline byte& Add(byte& a, byte b, bool& carry)
{
	int sum = a + int(b) + (carry ? 1 : 0);
	carry = (sum & 0xFF00) != 0;
	a = (byte)sum;
	return a;
}
inline byte& Subtract(byte& a, byte b, bool& carry)
{
	int c = (carry ? 1 : 0) ^ 1;
	int dif = a - int(b) - c;
	carry = (dif & 0xff00) == 0;
	a = (byte)dif;
	return a;
}

inline int NeededRotation(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
		assert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
	return DeltaDir;
}
inline int NeededRotationTime(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
		assert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	int Time = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
	{
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
		Time++;
	}
	return Time;
}

const int MaxAltLocations = 32;
class Object
{
public:
	char Status; //Negativ: Objekt explodiert gerade.
				 //0: Objekt nicht vorhanden.
				 //Positiv: Je nach Objekttyp. Bei...
				 //                            Asteroiden: Gre (1=klein, 2=mittel, 4=gro) Das originale Asteroids speichert hier auerdem in hheren Bits den Anzeigetyp
				 //                            Spieler: immer 1
				 //							   UFO: 2 (gro) oder 1 (klein)
				 //                            Schsse: ein herunterlaufender Timer
	union
	{
		word PositionX;
		word AltPX[MaxAltLocations];
	};
	union
	{
		char VelocityX;
		char AltVX[MaxAltLocations];
	};
	int cAltX;
	union
	{
		word PositionY;
		word AltPY[MaxAltLocations];
	};
	union
	{
		char VelocityY;
		char AltVY[MaxAltLocations];
	};
	int cAltY;
public:
	Object()
	{
	}

	Object(char Status)
	{
		this->Status = Status;
		cAltX = cAltY = 0;
	}

	void SetVelocity(char X, char Y)
	{
		for(int i = 0; i < cAltX; i++)
			AltVX[i] = X;
		for(int i = 0; i < cAltY; i++)
			AltVY[i] = Y;
		RemoveEqualities();
	}
	void SetVRamLocation(int x, int y, int VRamCounter)
	{
		//printf("vg: %x %x  cx: %i cy: %i\n", x*8, (y-128)*8, cAltX, cAltY);
		if(VRamCounter == 1)
		{
			for(int i = 0; i < 8; i++)
			{
				AltPX[i] = x*8+i;
				AltPY[i] = (y-128)*8+i;
			}
			cAltX = cAltY = 8;
		}
		else if(VRamCounter == 2)
		{
			assert(cAltX == 8 && cAltY == 8);
			for(int i = 0; i < 8; i++)
			{
				AltPX[i+8] = x*8+i;
				AltPY[i+8] = (y-128)*8+i;
			}
			cAltX = cAltY = 16;
		}
		else if(VRamCounter == 3)
		{
			assert(cAltX == 16 && cAltY == 16);

			word P1[8];
			memcpy(P1, AltPX, sizeof(word)*8);
			word P2[8];
			memcpy(P2, AltPX+8, sizeof(word)*8);
			word P3[8];
			for(int i = 0; i < 8; i++)
				P3[i] = x*8+i;
			cAltX = 0;
			char VX = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearX(P1[i], VX, 1), P2) && IsSet(MoveLinearX(P1[i], VX, 2), P3))
					{
						assert(cAltX < MaxAltLocations);
						AltPX[cAltX] = P1[i];
						AltVX[cAltX++] = VX;
					}
				}
			}while(++VX != -128);

			memcpy(P1, AltPY, sizeof(word)*8);
			memcpy(P2, AltPY+8, sizeof(word)*8);
			for(int i = 0; i < 8; i++)
				P3[i] = (y-128)*8+i;
			cAltY = 0;
			char VY = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearY(P1[i], VY, 1), P2) && IsSet(MoveLinearY(P1[i], VY, 2), P3))
					{
						assert(cAltY < MaxAltLocations);
						AltPY[cAltY] = P1[i];
						AltVY[cAltY++] = VY;
					}
				}
			}while(++VY != -128);

			assert(cAltX && cAltY, VRamInvalidException());
			MoveLinear(2);
		}
		else if(VRamCounter == 0)
		{
			//for(int i = 0; i < cAltX; i++)
			//	printf("%x oder ", AltPX[i]);
			for(int i = 0; i < cAltX;)
			{
				if(AltPX[i]/8 != x)
				{
					//printf("Entferne X %x passt nicht zu %x\n", AltPX[i], x*8);
					cAltX--;
					memcpy(AltPX+i, AltPX+i+1, (cAltX-i)*sizeof(word));
					memcpy(AltVX+i, AltVX+i+1, (cAltX-i)*sizeof(char));
				}
				else
					i++;
			}
			for(int i = 0; i < cAltY;)
			{
				if(AltPY[i]/8 != y-128)
				{
					cAltY--;
					memcpy(AltPY+i, AltPY+i+1, (cAltY-i)*sizeof(word));
					memcpy(AltVY+i, AltVY+i+1, (cAltY-i)*sizeof(char));
					//printf("Entferne Y\n");
				}
				else
					i++;
			}
			assert(cAltX && cAltY, VRamInvalidException());
		}
		else
			assert(0);
	}
	void AddLocation(word PositionX, word PositionY, char VelocityX, char VelocityY)
	{
		int i = 0;
		for(; i < cAltX; i++)
		{
			if(PositionX == AltPX[i] && VelocityX == AltVX[i])
				break;
		}
		if(i == cAltX)
		{
			assert(cAltX != MaxAltLocations);
			AltPX[i] = PositionX;
			AltVX[i] = VelocityX;
			cAltX++;
		}

		i = 0;
		for(; i < cAltY; i++)
		{
			if(PositionY == AltPY[i] && VelocityY == AltVY[i])
				break;
		}
		if(i == cAltY)
		{
			assert(cAltY != MaxAltLocations);
			AltPY[i] = PositionY;
			AltVY[i] = VelocityY;
			cAltY++;
		}
	}
	void Decide(int IndexX, int IndexY)
	{
		PositionX = AltPX[IndexX];
		VelocityX = AltVX[IndexX];
		PositionY = AltPY[IndexY];
		VelocityY = AltVY[IndexY];
		cAltX = cAltY = 1;
	}
	bool IsFixed() const
	{
		return cAltX == 1 && cAltY == 1;
	}
	void SetFixed()
	{
		cAltX = cAltY = 1;
	}
	bool IsValid() const
	{
		return cAltX && cAltY;
	}
	void MoveLinear(int Steps)
	{
		for(int i = 0; i < cAltX; i++)
			AltPX[i] = MoveLinearX(AltPX[i], AltVX[i], Steps);
		for(int i = 0; i < cAltY; i++)
			AltPY[i] = MoveLinearY(AltPY[i], AltVY[i], Steps);
	}
	bool ValidatePosition(word PositionX, word PositionY, char VelocityX, char VelocityY) const
	{
		for(int i = 0; i < cAltX; i++)
		{
			if(PositionX == AltPX[i] && VelocityX == AltVX[i])
			{
				for(int i = 0; i < cAltY; i++)
					if(PositionY == AltPY[i] && VelocityY == AltVY[i])
						return true;
				return false;
			}
		}
		return false;
	}
	void RemoveEqualities()
	{
		for(int i = 0; i < cAltX; i++)
		for(int j = i+1; j < cAltX;)
			if(AltPX[i] == AltPX[j] && AltVX[i] == AltVX[j])
				RemoveX(j);
			else
				j++;

		for(int i = 0; i < cAltY; i++)
		for(int j = i+1; j < cAltY;)
			if(AltPY[i] == AltPY[j] && AltVY[i] == AltVY[j])
				RemoveY(j);
			else
				j++;
	}
private:
	void RemoveX(int Index)
	{
		assert(cAltX && Index < cAltX);
		cAltX--;
		memcpy(AltPX+Index, AltPX+Index+1, (cAltX-Index)*sizeof(word));
		memcpy(AltVX+Index, AltVX+Index+1, (cAltX-Index)*sizeof(char));
	}
	void RemoveY(int Index)
	{
		assert(cAltY && Index < cAltY);
		cAltY--;
		memcpy(AltPY+Index, AltPY+Index+1, (cAltY-Index)*sizeof(word));
		memcpy(AltVY+Index, AltVY+Index+1, (cAltY-Index)*sizeof(char));
	}

	static bool IsSet(word Item, const word* Array, int cItems=8)
	{
		for(int i = 0; i < cItems; i++)
			if(Array[i] == Item)
				return true;
		return false;
	}
};

enum DecisionType
{
	//Die Typen sollten hier in der Reihenfolge stehen, wie sie in Move vorkommen
	DT_RandomSeed,
	DT_SaucerPositionBit,
	DT_AsteroidSplit,
};

/*
class DecisionKey
{
	DecisionType Type;
	int Time;
	int CollisionCauser, CollisionTarget;
private:
	DecisionKey()
	{
	}
public:
	static DecisionKey AsteroidSplit(int Time, int CollisionCauser, int CollisionTarget)
	{
		DecisionKey D;
		D.Type = DT_AsteroidSplit;
		D.Time = Time;
		D.CollisionCauser = CollisionCauser;
		D.CollisionTarget = CollisionTarget;
		return D;
	}
	static DecisionKey RandomSeed(int Time)
	{
		DecisionKey D;
		D.Type = DT_RandomSeed;
		D.Time = Time;
		return D;
	}
	static DecisionKey SaucerPositionBit(int Time)
	{
		DecisionKey D;
		D.Type = DT_SaucerPositionBit;
		D.Time = Time;
		return D;
	}

	//DecisionKey wird so sortiert, dass die zuletzt gemachten Entscheidungen zu Beginn stehen (am kleinsten sind).
	//(Das erste Element einer Map zu lschen ist am einfachsten)
	bool operator <(const DecisionKey& rhs) const
	{
		if(Time != rhs.Time)
			return Time > rhs.Time;
		if(Type != rhs.Type)
			return Type > rhs.Type;
		switch(Type)
		{
		case DT_RandomSeed:
			return false;//Nur eine Seedentscheidung pro Frame

		case DT_SaucerPositionBit:
			return false;//Diese Entscheidung muss nur beim ersten Auftauchen des UFOs gefllt werden

		case DT_AsteroidSplit:
			if(CollisionCauser != rhs.CollisionCauser)
				return CollisionCauser < rhs.CollisionCauser;
			return CollisionTarget < rhs.CollisionTarget;
		}
		assert(0);
		return false;
	}
	int GetTime() const
	{
		return Time;
	}
};

class Decision
{
	int NumTries;
public:
	Decision()
	{
	}
	Decision(int NumTries)
	{
		this->NumTries = NumTries;
	}
	//Gibt true zurck, wenn es keine Mglichkeiten mehr gibt
	bool NextDecision()
	{
		if(NumTries == 0)
			return true;
		NumTries--;
		return false;
	}
	int GetTriesLeft() const
	{
		return NumTries;
	}
};

typedef std::map<DecisionKey, Decision> DecisionList;
*/
class DecisionList
{
public:
	int Time;

	int Timer;
	int SaucerPositionBit;
	int ObjectCollision[PlayerShotMaxIndex - PlayerIndex + 1];
	int RandomSeed;
public:
	DecisionList(int Time)
	{
		this->Time = Time;

		Timer = -1;
		SaucerPositionBit = -1;
		for(int i = 0; i < PlayerShotMaxIndex - PlayerIndex + 1; i++)
			ObjectCollision[i] = -1;
		RandomSeed = -1;
	}

	//Wechselt zur nchsten Kombination
	//Gibt true zurck, wenn erfolgreich, oder false, wenn schon alle Kombinationen durch sind
	bool Next(bool& NextRandomSeed)
	{
		//Hier muss stark auf die Reihenfolge geachtet werden.
		//Zuerst mssen die Entscheidungen durchgegangen werden, die zuletzt in Move passieren.
		//Sonst kann es passieren, dass eine Entscheidung gendert wird und die nderung zur Folge
		//hat, dass eine darauffolgende Entscheidung garnicht stattfindet. (schwer zu erklren:))

		if(RandomSeed != -1 && --RandomSeed != -1)
		{
			NextRandomSeed = true;
			return true;
		}

		for(int i = 0; i < PlayerShotMaxIndex - PlayerIndex + 1; i++)
			if(ObjectCollision[i] != -1 && --ObjectCollision[i] != -1)
				return true;

		if(SaucerPositionBit != -1 && --SaucerPositionBit != -1)
			return true;

		if(Timer != -1 && --Timer != -1)
			return true;

		return false;
	}
	bool HasCombinations() const
	{
		bool Dummy;
		return DecisionList(*this).Next(Dummy);
	}
	bool operator <(const DecisionList& rhs) const
	{
		return Time > rhs.Time;
	}
};


//#include "AsteroidStartPositions.h"
const int DecisionTime = 10000;
const int NumSeedCombinations = 32767;

class ShotInfoList;
class ObjectsStateList;
class GameRam
{
public:
	int CurrentTime;
	int VRamCounter;

	bool RandomSeedKnown;
	bool SaucerPositionBitKnown;

	bool StartPrintedLastFrame, StartSwapNoticed;
	int TimerBitsKnown;
private:
	byte NumPlayers;
	byte PlayerScoreTens, PlayerScoreThousends;	
	byte NumShips;				
	char HyperSpaceStatus;		
public:
	byte FastTimer;
	byte RandomSeed1, RandomSeed2;
private:
	byte ShipDirection;
	byte FireHyperspaceToggle; //Hier wird gespeichert, ob im letzten Frame geschossen wurde
	byte AccX, AccY; //Acc steht fr Acceleration. Die Variablen zeigen aber nicht wirklich
					 //die Beschleunigung, sondern stellen einen Timer fr jede Komponente dar.
	                 //Bei jedem Durchlauf wird die Geschwindigkeit gendert, je nachdem, ob
	                 //man gerade Gas gibt oder nicht.
	                 //Habs einfach so genannt, weil ich beim Lesen des Maschinencodes noch
	                 //nicht wusste, was sie genau bedeuten..
	byte NumAsteroids, NumAsteroidsStart;
public:
	byte SaucerCountdown, SaucerCountdownStart;	
	byte _2F9;
	byte InvisibleTimer;		
	byte NewLevelStartCountdown;
	byte _2FD;
private:

	ShotInfo ShotInfosCheck[cPlayerShots];

public:
	Object Objects[NumObjects];
public:
	void StartNewGame()//loc_68DE
	{
		memset(this, 0, sizeof(*this));//Bitte nicht nachmachen! Endet schnell bse, wenn Member C++ Objekte sind, virtuelle Methoden vorhanden sind oder Vererbung im Spiel ist.
		NumPlayers = 0;
		NumShips = 3;
		RandomSeed1 = 5;
		NumAsteroidsStart = 2;
		InvisibleTimer = 1;
		SaucerCountdownStart = SaucerCountdown = 0x92;
		NewLevelStartCountdown = 0x7F;
		_2FD = 5;
		ResetPlayerPosition();
		for(int i = 0; i < cPlayerShots; i++)
			ShotInfosCheck[i] = ShotInfo();
		VRamCounter = 0;
		TimerBitsKnown = 0;
		SaucerPositionBitKnown = false;
		RandomSeedKnown = false;
		StartSwapNoticed = false;
	}

	void NextObject(int& Object, int MinIndex, int MaxIndex)
	{
		Object--;
		while(Object >= MinIndex)
		{
			if(Objects[Object].Status)
			{
				if(Object > MaxIndex)
					assert(0, VRamInvalidException());
				return;
			}
			Object--;
		}
		assert(0, VRamInvalidException());
	}

	bool CheckVRam(int& VRamScore, int& VRamNumShips, const word* VRam, const byte* ram)
	{
		//StartNewGame();

		assert(VRam[0] == 0xe001 || VRam[0] == 0xe201, VRamInvalidException());

		bool NumberRead = false;
		int Number = 0;
		int CountNumbers = 0;
		VRamScore = 0;
		int dx, dy, sf, vx, vy, vz, vs;
		int v1x = 0, v1y = 0;
		int shipdetect = 0;

		int Object = NumObjects;

		bool Preparing = false;
		int StartCounter = 0;
		bool StartPrinted = false;

		if(NumPlayers == 0)
		{
			memset(Objects, 0, sizeof(Objects));
			Object = AsteroidMaxIndex+1;
			VRamCounter = 1;
		}

		VRamNumShips = 0;

		
		for(int pc = 1; pc < 512;)
		{
			int op = VRam[pc] >> 12;
			switch(op)
			{
			case 0xa://LABS (Strahl positionieren)
				vy = VRam[pc] & 0x3ff;
				vx = VRam[pc+1] & 0x3ff;
				vs = VRam[pc+1] >> 12;
				if(NumberRead)
				{
					if(CountNumbers++ == 0)
						VRamScore = Number;
					Number = 0;
				}
				break;
			case 0xb://HALT (Programmende)
			case 0xd://RTSL
			case 0xe://JMPL
				pc = 512;
				break;
			case 0xc://JSRL (Subroutine aufrufen)
				switch(VRam[pc] & 0x0FFF)//Welche Adresse springen wir an?
				{
				case 0x880://Explosion
				case 0x896:
				case 0x8B5:
				case 0x8D0:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0 &&
							!(Object > SaucerIndex && Objects[SaucerIndex].Status < 0))
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, SaucerIndex);
						assert(Objects[Object].Status < 0, VRamInvalidException());
						Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
					}
					break;

				case 0x8f3://Asteroid
				case 0x8ff:
				case 0x90d:
				case 0x91a:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, AsteroidMaxIndex);
						if(vs == 0)//gro
							assert((Objects[Object].Status & 0x04) != 0, VRamInvalidException());
						else if(vs == 15)//mittel
							assert((Objects[Object].Status & 0x02) != 0, VRamInvalidException());
						else if(vs == 14)//klein
							assert((Objects[Object].Status & 0x01) != 0, VRamInvalidException());
						else
							assert(0, VRamInvalidException());
						Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
					}
					else
					{
						Object--;
						assert(Object >= AsteroidMinIndex && Object <= AsteroidMaxIndex, VRamInvalidException());
						if(vs == 0)//gro
							Objects[Object].Status = 0x04;
						else if(vs == 15)//mittel
							Objects[Object].Status = 0x02;
						else if(vs == 14)//klein
							Objects[Object].Status = 0x01;
						else
							assert(0, VRamInvalidException());
						Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
					}
					break;

				case 0x929://UFO
					if(NumPlayers)
					{
						NextObject(Object, SaucerIndex, SaucerIndex);
						if(vs == 15)//gro
							assert(Objects[Object].Status == 2, VRamInvalidException());
						else if(vs == 14)//klein
							assert(Objects[Object].Status == 1, VRamInvalidException());
						else
							assert(0, VRamInvalidException());
						Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
					}
					break;

				case 0xa6d://Lebenanzeige
					VRamNumShips++;
					break;

				//Ziffern:
				case 0xadd: NumberRead = true; Number = Number*10 + 0; break;
				case 0xb2e: NumberRead = true; Number = Number*10 + 1; break;
				case 0xb32: NumberRead = true; Number = Number*10 + 2; break;
				case 0xb3a: NumberRead = true; Number = Number*10 + 3; break;
				case 0xb41: NumberRead = true; Number = Number*10 + 4; break;
				case 0xb48: NumberRead = true; Number = Number*10 + 5; break;
				case 0xb4f: NumberRead = true; Number = Number*10 + 6; break;
				case 0xb56: NumberRead = true; Number = Number*10 + 7; break;
				case 0xb5b: NumberRead = true; Number = Number*10 + 8; break;
				case 0xb63: NumberRead = true; Number = Number*10 + 9; break;

				

				//"START" aus zB "PUSH START" abfangen. (Kommt in allen Sprachen vor). Da die Anzeige synchron
				//mit dem Timer blinkt, knnen wir herausfinden, wie dieser intern ist.
				case 0xAFB: /*S*/ StartCounter = 1; break;
				case 0xB02: /*T*/ if(StartCounter == 1) StartCounter++; else if(StartCounter == 4) StartPrinted = true; else StartCounter = 0; break;
				case 0xA78: /*A*/ if(StartCounter == 2) StartCounter++; else StartCounter = 0; break;
				case 0xAF3: /*R*/ if(StartCounter == 3) StartCounter++; else StartCounter = 0; break;

				//Buchstabe 'E' abfangen. Es wird wahrscheinlich "Spieler", "Player", "Game Over" o.. angezeigt. Jedenfalls knnen wir nicht steuern
				case 0xA9B:
					StartCounter = 0;
					Preparing = true;
					break;

				//Alle anderen Buchstaben
				case 0xA80://B
				case 0xA8D://C
				case 0xA93://D
				case 0xAA3://F
				case 0xAAA://G
				case 0xAB3://H
				case 0xABA://I
				case 0xAC1://J
				case 0xAC7://K
				case 0xACD://L
				case 0xAD2://M
				case 0xAD8://N
				//O wird durch 0 angezeigt
				case 0xAE3://P
				case 0xAEA://Q
				case 0xB08://U
				case 0xB0e://V
				case 0xB13://W
				case 0xB1a://X
				case 0xB1f://Y
				case 0xB26://Z
					StartCounter = 0;
					break;
				}
				break;
			default:
			{
				dy = VRam[pc] & 0x3ff;
				if(VRam[pc] & 0x400)
					dy = -dy;
				dx = VRam[pc+1] & 0x3ff;
				if(VRam[pc+1] & 0x400)
					dx = -dx;
				sf = VRam[pc] >> 12;
				vz = VRam[pc+1] >> 12;
				if(NumPlayers && dx == 0 && dy == 0 && vz == 15)
				{
					NextObject(Object, SaucerShotMinIndex, PlayerShotMaxIndex);
					Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
				}
				if(op == 6 && vz == 12 && dx != 0 && dy != 0)
				{
					switch (shipdetect)
					{
					case 0:
						v1x = dx;
						v1y = dy;
						++shipdetect;
						break;
					case 1:
						if(NumPlayers)
						{
							NextObject(Object, PlayerIndex, PlayerIndex);
							assert(Objects[Object].Status == 1, VRamInvalidException());
							Objects[Object].SetVRamLocation(vx, vy, VRamCounter);
						}
						else
						{
							Objects[PlayerIndex].Status = 1;
							Objects[PlayerIndex].SetVRamLocation(vx, vy, VRamCounter);
						}
//						game.ship_dx = v1x - dx;
//						game.ship_dy = v1y - dy;
						++shipdetect;
						break;
					}
				}
				else if (shipdetect == 1)
					shipdetect = 0;
				break;
			}
			}
			if(op <= 0xa)
				++pc;
			if(op != 0xe) // JMPL
				++pc;
		}
		if(NumPlayers)
		{
			//Alle anderen Objekte mssen auch bei uns weg sein:
			if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
				NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
			while(--Object >= 0)
				assert(Objects[Object].Status == 0, VRamInvalidException());
		}
		if(TimerBitsKnown < 6 && StartPrinted && !StartPrintedLastFrame && CurrentTime)
		{
			if(StartSwapNoticed && (FastTimer&0x3F) == 0)
			{
				TimerBitsKnown = 6;
				printf("6 Timerbits1\n");
			}
			else if((FastTimer&1) == 0)
			{
				FastTimer = 0;
				StartSwapNoticed = true;
			}
		}
		else if(TimerBitsKnown < 6 && !StartPrinted && StartPrintedLastFrame && CurrentTime)
		{
			if(StartSwapNoticed && (FastTimer&0x3F) == 0x20)
			{
				TimerBitsKnown = 6;
				printf("6 Timerbits2\n");
			}
			else if((FastTimer&1) == 0)
			{
				FastTimer = 0x20;
				StartSwapNoticed = true;
			}
		}
		else if(TimerBitsKnown < 1)
		{
			//Das erste Byte zeigt auf den aktuellen Vektorpuffer, welcher jeden Frame synchron mit dem Timer wechselt.
			//Wir wissen also wenigstens, ob der Timer gerade oder ungerade ist.
			FastTimer = VRam[0] == 0xe001 ? 0 : 1;
			TimerBitsKnown = 1;
			printf("1 Timerbit\n");
		}
		StartPrintedLastFrame = StartPrinted;
		//printf("Zahlen: %i\n", CountNumbers);
		if(CountNumbers == 3 || Preparing)
			return false;
		if(NumPlayers == 0)
		{
			printf("Starte neues Spiel!\n");
			NumPlayers = 1;
			NumAsteroids = AsteroidMaxIndex+1-Object;
			NumAsteroidsStart = 4;
			InvisibleTimer = 0;
			NewLevelStartCountdown = 0;
			SaucerCountdown = ram[0x02F7];
			SaucerCountdownStart = ram[0x02F8];
			//assert(Object == AsteroidMaxIndex+1-4);////////////////////////
/*			for(int i = 0; i < _countof(AsteroidStartPositions); i++)
			{
				::Object CorrectAsteroids[4];
				int j = 0;
				for(; j < 4; j++)
				{
					if(Objects[j+1+AsteroidMaxIndex-4].PositionX/8 >= AsteroidStartPositions[i].Asteroids[j].MinComponent && Objects[j+1+AsteroidMaxIndex-4].PositionX/8 <= AsteroidStartPositions[i].Asteroids[j].MaxComponent &&
					   AsteroidStartPositions[i].Asteroids[j].ExactComponent/8 == Objects[j+1+AsteroidMaxIndex-4].PositionY/8)
					{
						CorrectAsteroids[j].Status = Objects[j+1+AsteroidMaxIndex-4].Status;
						CorrectAsteroids[j].PositionX = Objects[j+1+AsteroidMaxIndex-4].PositionX;
						CorrectAsteroids[j].PositionY = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else if(Objects[j+1+AsteroidMaxIndex-4].PositionY/8 >= AsteroidStartPositions[i].Asteroids[j].MinComponent && Objects[j+1+AsteroidMaxIndex-4].PositionY/8 <= AsteroidStartPositions[i].Asteroids[j].MaxComponent &&
					        AsteroidStartPositions[i].Asteroids[j].ExactComponent/8 == Objects[j+1+AsteroidMaxIndex-4].PositionX/8)
					{
						CorrectAsteroids[j].Status = Objects[j+1+AsteroidMaxIndex-4].Status;
						CorrectAsteroids[j].PositionX = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
						CorrectAsteroids[j].PositionY = Objects[j+1+AsteroidMaxIndex-4].PositionY;
						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else
						break;
				}
				if(j == 4)
					printf("Seed gefunden! %x %x\n", AsteroidStartPositions[i].s1, AsteroidStartPositions[i].s2);
			}
			MessageBeep(0);*/
		}
		if(VRamCounter && ++VRamCounter == 4)
			VRamCounter = 0;
		return true;
#if 0
	#ifdef _DEBUG
	   char scorestr[32] = "";             // Platz fr 3 Zahlen zu max 100000
	   const GameStatus lastgame = game;   // vorherige Werte merken zum Vergleich
	#endif

	   const unsigned __int8 *vector_ram = packet.vectorram;
	   int dx, dy, vx, vy, vz, vs;
	/*   int sf; */
	   int v1x = 0;
	   int v1y = 0;
	   int shipdetect = 0;
	   unsigned int points = 0;
	   int numofdigits = 0;    // < 0 bedeutet fertig
	   char textstr[64];
	   int numofchars = 0;

	   game.clear();
	   if (oldgamestate == GameStatus::standby)
	   {  // Sonderbehandlung: "STARTKNOEPFE" blinkt, daher mal da und mal nicht
		  game.state = GameStatus::standby;
	   }

	   /* Bemerkung:
		  unsigned __int16 value = vector_ram[i] | (vector_ram[i+1] << 8);
		  statt
		  unsigned __int16 value = reinterpret_cast<unsigned __int16*>(vector_ram)[i>>1];
		  damit unabhngig von der Darstellung des Prozessors
		  (Little- oder Big-Endian).
	   */
	   {
		  unsigned __int16 value = vector_ram[0] | (vector_ram[1] << 8);
		  if (value != 0xe001 && value != 0xe201)
			 return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
	   }

	   for (unsigned int pc = 2; pc < sizeof packet.vectorram;)
	   {
		  unsigned __int16 value = vector_ram[pc] | (vector_ram[pc+1] << 8);
		  int op = value >> 12;
		  switch (op)
		  {
			 case 0xa: // LABS (Strahl positionieren)
			 {
				vy = value & 0x3ff;
				unsigned __int16 value2 = vector_ram[pc+2] | (vector_ram[pc+3] << 8);
				vx = value2 & 0x3ff;
				vs = value2 >> 12;

				if (numofdigits > 0)
				{  // Score sind die zuerst auftretenden Zahlen
	#ifdef _DEBUG
				   scorestr[numofdigits] = '\0';
	#endif
				   numofdigits = -numofdigits;
				   numofchars = 0;      // wegen 0 = O
				}

				break;
			 }
			 case 0xb: // HALT (Programmende)
				goto end;
			 case 0xc: // JSRL (Subroutine aufrufen)
			 {
				switch (value & 0xfff)
				{
				   case 0x880:    // Explosion gro (3)
					  game.explosions[game.nexplosions++].set(vx, vy, 3, vs);
					  break;
				   case 0x896:    // Explosion (2)
					  game.explosions[game.nexplosions++].set(vx, vy, 2, vs);
					  break;
				   case 0x8B5:    // Explosion (1)
					  game.explosions[game.nexplosions++].set(vx, vy, 1, vs);
					  break;
				   case 0x8D0:    // Explosion klein (0)
					  game.explosions[game.nexplosions++].set(vx, vy, 0, vs);
					  break;
				   case 0x8f3:    // Asteroid Typ 1
					  game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
					  if (vs == 0)
						 ++game.nbigasteroid;
					  else if (vs == 15)
						 ++game.nmidasteroid;
					  else
						 ++game.nsmallasteroid;
					  break;
				   case 0x8ff:    // Asteroid Typ 2
					  game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
					  if (vs == 0)
						 ++game.nbigasteroid;
					  else if (vs == 15)
						 ++game.nmidasteroid;
					  else
						 ++game.nsmallasteroid;
					  break;
				   case 0x90d:    // Asteroid Typ 3
					  game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
					  if (vs == 0)
						 ++game.nbigasteroid;
					  else if (vs == 15)
						 ++game.nmidasteroid;
					  else
						 ++game.nsmallasteroid;
					  break;
				   case 0x91a:    // Asteroid Typ 4
					  game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
					  if (vs == 0)
						 ++game.nbigasteroid;
					  else if (vs == 15)
						 ++game.nmidasteroid;
					  else
						 ++game.nsmallasteroid;
					  break;
				   case 0x929:    // Ufo
					  game.saucer.set (vx, vy, vs);
					  break;
				   // Lebenerkennung
				   case 0xa6d:
					  ++game.lifes;
					  break;
				   // PUNKTEerkennung
				   case 0xadd:    // Ziffer 0 oder O
					  ADDCHAR ('O');
					  if (numofdigits >= 0)
						 ADDDIGIT(0);
					  break;
				   case 0xb2e:    // Ziffer 1
					  if (numofdigits >= 0)
						 ADDDIGIT(1);
					  break;
				   case 0xb32:    // Ziffer 2
					  if (numofdigits >= 0)
						 ADDDIGIT(2);
					  break;
				   case 0xb3a:    // Ziffer 3
					  if (numofdigits >= 0)
						 ADDDIGIT(3);
					  break;
				   case 0xb41:    // Ziffer 4
					  if (numofdigits >= 0)
						 ADDDIGIT(4);
					  break;
				   case 0xb48:    // Ziffer 5
					  if (numofdigits >= 0)
						 ADDDIGIT(5);
					  break;
				   case 0xb4f:    // Ziffer 6
					  if (numofdigits >= 0)
						 ADDDIGIT(6);
					  break;
				   case 0xb56:    // Ziffer 7
					  if (numofdigits >= 0)
						 ADDDIGIT(7);
					  break;
				   case 0xb5b:    // Ziffer 8
					  if (numofdigits >= 0)
						 ADDDIGIT(8);
					  break;
				   case 0xb63:    // Ziffer 9
					  if (numofdigits >= 0)
						 ADDDIGIT(9);
					  break;
				   //PUNKTEerkennung ende
				   case 0xb2c:    // Leerzeichen (Punkte- oder Zustanderkennung)
				   {
					  if (numofchars > 0)
					  {  // Leerzeichen beenden Wort --> Vergleiche fr Zustandserkennung
						 textstr[numofchars] = '\0';
						 if (strcmp (textstr, "STARTKNOEPFE") == 0)
							game.state = GameStatus::standby;
						 else if (strcmp (textstr, "SPIELER") == 0)
							game.state = GameStatus::starting;
						 else if (strcmp (textstr, "SPIELENDE") == 0)
							game.state = GameStatus::gameover;
						 else if (strcmp (textstr, "BUCHSTABENWAHL") == 0)
							game.state = GameStatus::highscore;
							// "ERGEBNIS" wird auch auf der Startseite angezeigt,
							// wenn bereits ein highscore existiert
							// Zeilenumbrche existieren nicht, daher "BESTENBITTE"
					  }
					  numofchars = 0;      // wegen 0 = O
					  break;
				   }

				   // Worterkennung fr Zustnde
				   case 0xA78: ADDCHAR ('A'); break;
				   case 0xA80: ADDCHAR ('B'); break;
				   case 0xA8D: ADDCHAR ('C'); break;
				   case 0xA93: ADDCHAR ('D'); break;
				   case 0xA9B: ADDCHAR ('E'); break;
				   case 0xAA3: ADDCHAR ('F'); break;
				   case 0xAAA: ADDCHAR ('G'); break;
				   case 0xAB3: ADDCHAR ('H'); break;
				   case 0xABA: ADDCHAR ('I'); break;
				   case 0xAC1: ADDCHAR ('J'); break;
				   case 0xAC7: ADDCHAR ('K'); break;
				   case 0xACD: ADDCHAR ('L'); break;
				   case 0xAD2: ADDCHAR ('M'); break;
				   case 0xAD8: ADDCHAR ('N'); break;
	//               case 0xADD: ADDCHAR ('O'); break;       siehe Ziffer 0
				   case 0xAE3: ADDCHAR ('P'); break;
				   case 0xAEA: ADDCHAR ('Q'); break;
				   case 0xAF3: ADDCHAR ('R'); break;
				   case 0xAFB: ADDCHAR ('S'); break;
				   case 0xB02: ADDCHAR ('T'); break;
				   case 0xB08: ADDCHAR ('U'); break;
				   case 0xB0e: ADDCHAR ('V'); break;
				   case 0xB13: ADDCHAR ('W'); break;
				   case 0xB1a: ADDCHAR ('X'); break;
				   case 0xB1f: ADDCHAR ('Y'); break;
				   case 0xB26: ADDCHAR ('Z'); break;
				   // Worterkennung fr Zustnde ende
				}
				break;
			 }
			 case 0xd: // RTSL (Rckkehr Subroutine)
				goto end;
			 case 0xe: // JMPL (Unbedingter Sprung)
				/*
				pc = (value & 0xfff) << 1;
				break;
				*/
				goto end;
			 case 0xf: // SVEC (kurzer Vektor)
				/*
				dy = value & 0x300;
				if ((value & 0x400) != 0)
				   dy = -dy;
				dx = (value & 3) << 8;
				if ((value & 4) != 0)
				   dx = -dx;
				sf = (((value & 8) >> 2) | ((value & 0x800) >> 11)) + 2;
				vz = (value & 0xf0) >> 4;
				*/
				break;
			 default:
			 {
				unsigned __int16 value2 = vector_ram[pc+2] | (vector_ram[pc+3] << 8);
				dy = value & 0x3ff;
				if ((value & 0x400) != 0)
				   dy = -dy;
				dx = value2 & 0x3ff;
				if ((value2 & 0x400) != 0)
				   dx = -dx;
				/* sf = op;  ??? */
				vz = value2 >> 12;
				if (dx == 0 && dy == 0 && vz == 15)
				   game.shots[game.nshots++].set(vx, vy);

				if ((op == 1 || op == 2) && vz == 0)
				   shiplost = true;
				// Vermutung: op == 1 oder op == 2 und vz == 0 sind die Schiffsexplosionen
				if (op == 6 && vz == 12 && dx != 0 && dy != 0)
				{
				   switch (shipdetect)
				   {
					  case 0:
						 v1x = dx;
						 v1y = dy;
						 ++shipdetect;
						 break;
					  case 1:
						 game.state = GameStatus::playing;
						 inhyperspace = false;
						 shiplost = false;
						 game.ship.set(vx, vy, v1x - dx, v1y - dy);
						 ++shipdetect;
							// hat dann Wert == 2 ...
						 break;
				   }
				}
				else if (shipdetect == 1)
				   shipdetect = 0;

				break;
			 }
		  }
		  if (op <= 0xa)
			 pc+=2;
		  if (op != 0xe) // JMPL
			 pc+=2;
	   }

	end:
	   // Zustandskorrektur
	   if (game.state == GameStatus::unknown && !game.ship.present
		  && oldgamestate == GameStatus::playing)
		  game.state = GameStatus::playing;
		  // wird nur bei aktiven Schiff sonst gesetzt
	#ifdef _DEBUG
	   if (oldgamestate != GameStatus::highscore
		  && game.state < oldgamestate)
		  OutputWarning ("Zustandsreihenfolge offenbar falsch.");
	#endif

	#if 0
	   // reinnehmen, wenn shiplost funktioniert
	   if (!shiplost && !game.ship.present)
		  inhyperspace = true;
	#endif

	   // Events bestimmen
	   if (game.state == GameStatus::playing || oldgamestate == GameStatus::playing)
	   {
		  if (game.state == GameStatus::playing && oldgamestate != GameStatus::starting)
		  {  // gelesene Punkt bernehmen (beim Wechsel wre es falsch)
	#ifdef _DEBUG
			 unsigned int oldscore = game.score;
	#endif

			 if (lastframepoints > points)
				game.score += 100000;
			 game.score += points - lastframepoints;
			 lastframepoints = points;
		  }
		  if ((!game.ship.present && shipwaspresent && !inhyperspace)
			 || lastlifes > game.lifes)
			 game.events = (GameStatus::Event) (game.events | GameStatus::ship_lost);
		  if (game.nbigasteroid > lastnbigasteroid && lastnbigasteroid <= 2)
		  {
			 game.events = (GameStatus::Event) (game.events |
				(game.level == 0 ? GameStatus::gamestart : GameStatus::nextlevel));
			 ++game.level;
			 // Level ist geraten und falsch, wenn mitten im Spiel startet
		  }
		  if (lastnbigasteroid > game.nbigasteroid
			 || lastnmidasteroid > game.nmidasteroid
			 || lastnsmallasteroid > game.nsmallasteroid)
		  {
			 game.events = (GameStatus::Event) (game.events
				| GameStatus::asteroid_destroyed);
			 // Zerstrung eines Asteroiden fhrt zu zwei neue der kleineren Gre
			 // Unter beachtung aller Zahlen knnte man ein Gleichungsystem lsen,
			 // das als Lsung die Zahl der zerstrten Asteroiden jeder Kategorie hat
		  }
		  if (lastsaucersize > 0 && lastsaucersize != game.saucer.size)
		  {
			 game.events = (GameStatus::Event) (game.events
				| GameStatus::saucer_destroyed);
		  }
		  // Alternative: Punktestanderhhung betrachten und zerlegen
		  // numerisch anspruchsvoll, da mehrere Objekte gleichzeitig mglich
		  // Aber nicht richtig: Ufo kann mit Asteroiden zusammenstossen, keine Punkte
		  if (!game.ship.present && shipwaspresent && inhyperspace)
		  {
			 game.events = (GameStatus::Event) (game.events
				| GameStatus::ship_inhyperspace);
		  }

		  if (lastlifes < game.lifes)
		  {
			 game.events = (GameStatus::Event) (game.events
				| GameStatus::newlife);
			 // neues Leben gibt es offenbar mit jedem 10000er Schritt
		  }
	   }
	   if (oldgamestate != game.state)
	   {
		  game.events = (GameStatus::Event) (game.events
			 | GameStatus::state_changed);
	   }
	   // aktuelle Daten speichern
	   lastnbigasteroid = game.nbigasteroid;
	   lastnmidasteroid = game.nmidasteroid;
	   lastnsmallasteroid = game.nsmallasteroid;
	   lastsaucersize = game.saucer.size;
	   oldgamestate = game.state;
	   shipwaspresent = game.ship.present;
	   lastlifes = game.lifes;

	#ifdef _DEBUG
	   if (game.events & GameStatus::state_changed)
		  OutputDebug (ToString(game.state));
	   if (game.events & ~GameStatus::state_changed)
		  OutputDebug (ToString((GameStatus::Event)(game.events & ~GameStatus::state_changed)));
	   if ((game.events & (GameStatus::newlife | GameStatus::ship_lost | GameStatus::nextlevel)) ||
		  ((game.events & GameStatus::state_changed) && (game.state == GameStatus::gameover)))
	   {
		  OutputDebug2 ("Score: %u, Leben: %u, Level: %u",
			 game.score, game.lifes, game.level);
	   }
	#endif
#endif
	}


	const Object* GetObjects() const
	{
		return Objects;
	}
	void CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety);
//	void CalculateNextShot(std::vector<ShotInfo>& ShotInfos, int& MaxCollisionTime, int MinShootTime);
	void SimulateShot(ObjectsStateList& ObjectsStates, const ShotInfoList& ShotInfos, const int CurrentObjectsStates, const int CurrentShotInfo, const int cShotsShot, const int t, GameRam& OriginalRam, const int ShotIndex, const int DeltaDir, int& MinCollisionAtTime, std::multiset<ShotInfoList>& ShotInfosVariety, bool RotationWasLocked);
	void CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime);

	int GetCountExtraSlots() const
	{
		int CountExtraSlots = 0;
		for(int i = PlayerShotMinIndex; i <= PlayerShotMaxIndex; i++)
			if(Objects[i].Status == 0)
				CountExtraSlots++;
		return CountExtraSlots;
	}

	void Render(HDC hdcScreen, int cx, int cy);
	bool Check(const byte* ram, const KeysPacket& keys, const ShotInfo& ShotInfo, bool set, ADDRESS server_ip, SOCKET sd)
	{
		if(byte(FastTimer << (8-TimerBitsKnown)) != byte(ram[0x5C] << (8-TimerBitsKnown)))
			return false;

		if(VRamCounter || !NumPlayers)
			return true;
		if(RandomSeedKnown)
			if(RandomSeed1 != ram[0x5F] || RandomSeed2 != ram[0x60])
				return false;
		//return;
/*		byte s1 = Var(RAM_RandomSeed1);
		byte s2 = Var(RAM_RandomSeed2);
		Rand();
		int i = 0;
		while(s1 != Var(RAM_RandomSeed1) || s2 != Var(RAM_RandomSeed2))
		{
			printf("%i: %x%x\n", ++i, Var(RAM_RandomSeed1), Var(RAM_RandomSeed2));
			Rand();
		}
		while(true);*/

		struct
		{
			byte* pVariable;
			int Address;
		}
		VariableAddresses[] =
		{
			&NumPlayers,			   0x1C,
			&PlayerScoreTens,		   0x52,
			&PlayerScoreThousends,	   0x53,
			//&NumShips,				   0x57,
			(byte*)&HyperSpaceStatus,  0x59,
			//&RandomSeed1,			   0x5F,
			//&RandomSeed2,			   0x60,
			//&ShipDirection,			   0x61,
			&FireHyperspaceToggle,	   0x63,
			//&AccX,					   0x64,
			//&AccY,					   0x65,
			&NumAsteroidsStart,        0x02F5,
			&NumAsteroids,			   0x02F6,
			&SaucerCountdown,		   0x02F7,
			&SaucerCountdownStart,	   0x02F8,
			&_2F9,					   0x02F9,
			&InvisibleTimer,		   0x02FA,
			&NewLevelStartCountdown,   0x02FB,
			&_2FD,                     0x02FD
		};


		if(set)
		{
			for(int i = 0; i < _countof(VariableAddresses); i++)
				*VariableAddresses[i].pVariable = ram[VariableAddresses[i].Address];
			for(int i = 0; i < NumObjects; i++)
			{
				Objects[i].Status = char(ram[0x200+i]);
				Objects[i].VelocityX = char(ram[0x223+i]);
				Objects[i].VelocityY = char(ram[0x246+i]);
				Objects[i].PositionX = MakeWord(ram[0x269+i], ram[0x2AF+i]);
				Objects[i].PositionY = MakeWord(ram[0x28C+i], ram[0x2D2+i]);
			}
			return true;
		}

		//assert(byte(ram[0x61]-ShipDirection) >= 0 && byte(ram[0x61]-ShipDirection) <= ShipDirectionMaxDelta);

		bool errors = false;
		for(int i = 0; i < _countof(VariableAddresses); i++)
			if(//i!=RAM_RandomSeed1 && i!=RAM_RandomSeed2 &&
				//i!=RAM_FireHyperspaceToggle &&
				//VariableAddresses[i].pVariable!=&NumShips &&
				//i!=RAM_PlayerScoreTens && i!=RAM_PlayerScoreThousends &&
				//VariableAddresses[i].pVariable!=&SaucerCountdown && VariableAddresses[i].pVariable!=&SaucerCountdownStart &&
				//i!=RAM_PositionExactX && i!=RAM_PositionExactY &&
				//i!=RAM_PositionX && i!=RAM_PositionY &&
				//i!=RAM_VelocityY && i!=RAM_AccY &&
				*VariableAddresses[i].pVariable != ram[VariableAddresses[i].Address])
			{
				//printf("No: %i Byte an Adresse %x verschieden: berechnet: %x tatschlich %x\n",
				//	No, VariableAddresses[i].Address, *VariableAddresses[i].pVariable, ram[VariableAddresses[i].Address]);
				return false;
				//errors = true;
			}


		for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
			if(Objects[i].Status <= 0)
				if(Objects[i].Status != char(ram[0x200+i]))
					return false;
			else
				if((Objects[i].Status&7) != (ram[0x200+i]&7))
					return false;

		if(Objects[PlayerIndex].Status != char(ram[0x200+PlayerIndex]))
			return false;
		if(Objects[SaucerIndex].Status != char(ram[0x200+SaucerIndex]))
			return false;
		for(int i = SaucerShotMinIndex; i <= PlayerShotMaxIndex; i++)
			if((Objects[i].Status!=0) != (ram[0x200+i]!=0))
				return false;

		for(int i = 0; i < NumObjects; i++)
		{
			/*if( Objects[i].Status != char(ram[0x200+i]) ||
			Objects[i].VelocityX != char(ram[0x223+i]) ||
			Objects[i].VelocityY != char(ram[0x246+i]) ||
			Objects[i].PositionX != MakeWord(ram[0x269+i], ram[0x2AF+i]) ||
			Objects[i].PositionY != MakeWord(ram[0x28C+i], ram[0x2D2+i]))
			{
			printf("Byte bei Obj %x\n", i);
			errors = true;
			}*/
			if(Objects[i].Status)
				if(!Objects[i].ValidatePosition(MakeWord(ram[0x269+i], ram[0x2AF+i]), MakeWord(ram[0x28C+i], ram[0x2D2+i]),
												char(ram[0x223+i]), char(ram[0x246+i])))
					return false;
		}

		/*if(errors)
		{
			sockaddr_in server;
			memset(&server, 0, sizeof server);
			server.sin_family = AF_INET;
			server.sin_port = htons(1979);
			server.sin_addr.s_addr = server_ip;
			sendto(sd, "stop", 5, 0, (sockaddr*)&server, sizeof server);
		}*/


		while(errors)
		{
			*this = last_ram;
			//Move_(keys, ShotInfo, ram, 0, 0);
		}
		return true;

	}
	static GameRam last_ram;
	void Move(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		KeysPacket keys;
#ifdef USER_CONTROL
		if(GetAsyncKeyState('Q') < 0)
			keys.left(true);
		if(GetAsyncKeyState('W') < 0)
			keys.right(true);
		if(GetAsyncKeyState('I') < 0)
			keys.thrust(true);
		if(GetAsyncKeyState('O') < 0)
			keys.fire(true);
		if(GetAsyncKeyState(VK_SPACE) < 0)
			keys.hyperspace(true);
#else
		assert(CurrentShotInfo.Time >= CurrentTime);
		if(CurrentShotInfo.Time != MaxInt && ShipDirection != CurrentShotInfo.TargetDirection)
		{
			keys.FromDirection(CurrentShotInfo.Dir);
		}
		if(CurrentShotInfo.Time == CurrentTime)
		{
			assert(ShipDirection == CurrentShotInfo.TargetDirection);
			assert(NextShotInfo.Time > CurrentTime);
			keys.fire(true);
			if(NextShotInfo.Time != MaxInt && ShipDirection != NextShotInfo.TargetDirection)
				keys.FromDirection(NextShotInfo.Dir);
			else
				keys.FromDirection(Dir_None);
		}
#endif
		////////Move_(keys, CurrentShotInfo, 0, 0);
	}
	bool Move_(const KeysPacket& keys, const ShotInfo& ShotInfo, const byte* ram, const word* VRam, DecisionList& Decisions)
	{
#if 0
		FILE* out = fopen("blabla.txt", "w");
	
		byte s1 = 0, s2 = 0;

		std::set<int> seeds;
		RandomSeed1 = s1;
		RandomSeed2 = s2;
		int h = 0;
		do
		{
			NumAsteroidsStart = 2;
			Objects[SaucerIndex].Status = 0;
			NewLevelStartCountdown = 0;
			ResetAsteroids();
			fprintf(out, "\t{ 0x%02x, 0x%02x, 0x%02x, 0x%02x, { ", s1, s2, RandomSeed1, RandomSeed2);
			for(int i = AsteroidMaxIndex-4+1; i <= AsteroidMaxIndex; i++)
			{
				if(Objects[i].PositionY == 0)
				{
					assert(Objects[i].PositionX != 0);
					LowByte(Objects[i].PositionX) = 0;
					word MinX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					LowByte(Objects[i].PositionX) = 0xff;
					word MaxX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
					fprintf(out, "{ 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						MinX, MaxX, Objects[i].PositionY,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else if(Objects[i].PositionX == 0)
				{
					LowByte(Objects[i].PositionY) = 0;
					word MinY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					LowByte(Objects[i].PositionY) = 0xff;
					word MaxY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
					fprintf(out, "{ 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						MinY, MaxY, Objects[i].PositionX,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else
					assert(0);
				//PreMoveObject(i);
			}
			fprintf(out, "} },\n");
			RandomSeed1 = s1;
			RandomSeed2 = s2;
			Rand();
			s1 = RandomSeed1;
			s2 = RandomSeed2;
			printf("%i\n", h++);
			if(seeds.find(MakeWord(s1,s2)) != seeds.end())
				break;
			seeds.insert(MakeWord(s1,s2));
		}while(RandomSeed1 || RandomSeed2);
		fclose(out);
		exit(0);
#endif



		//printf("Eigener Frame: Hash: %x\n", GetHash());
		//printf("Move Key: %x\n", keys.keys & 0x1f);
		last_ram = *this;
		
		FastTimer++;

		if(NumPlayers && !VRamCounter)
			NeedTimerBits(2, Decisions);

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status == 0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
			//if(cShips == 0) loc_69CF();
			//sub_702D
			SaucerCountdown = SaucerCountdownStart;
			Objects[SaucerIndex].Status = 0;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
		}

		Shoot(keys, ShotInfo);
		DoHyperSpace(keys);
		UpdateHyperspace(keys); //Ruft UpdateDirectionAndThrust() auf
		UpdateSaucer(Decisions);

		//Objekte aktualisieren
		if(!VRamCounter)
			for(int i = NumObjects-1; i >= 0; i--)
				PreMoveObject(i);

		int VRamScore, VRamNumShips;
		if(!CheckVRam(VRamScore, VRamNumShips, VRam, ram))
		{
			CurrentTime++;
			return false;
		}

		for(int i = NumObjects-1; i >= 0; i--)
			PostMoveObject(i);

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		for(int i = PlayerShotMaxIndex; i >= PlayerIndex; i--)
			CheckCollisions(i, Decisions);

		////////////assert(DecimalToBin(PlayerScoreThousends, PlayerScoreTens)*10 == VRamScore);
		///////////////assert(NumShips == VRamNumShips);

		Rand();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
			ResetAsteroids();
		CurrentTime++;
		//printf("Move Ende\n");
		return true;
	}
	byte GetHash()
	{
		byte h = RandomSeed1 + RandomSeed2;
		for(int i = 0; i < NumObjects; i++)
		{
			h += Objects[i].Status;
			h += Objects[i].VelocityX + Objects[i].VelocityY;
			h += LowByte(Objects[i].PositionX) + HighByte(Objects[i].PositionX);
			h += LowByte(Objects[i].PositionY) + HighByte(Objects[i].PositionY);
		}
		return h;
	}

	void Shoot(const KeysPacket& keys, const ShotInfo& ShotInfo)//sub_6CD7
	{
		if(NumPlayers == 0)
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}
		FireHyperspaceToggle >>= 1;
		if(keys.keys & KeysPacket::KEY_FIRE)
			FireHyperspaceToggle |= 0x80;

		if(!(keys.keys & KeysPacket::KEY_FIRE) || //nicht gedrckt?
			FireHyperspaceToggle & 0x40 || //letzten Frame schon gedrckt?
			InvisibleTimer) //unsichtbar?
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}

		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
			{
				assert(ShotInfo.Time > CurrentTime);
				return;
			}
#ifndef USER_CONTROL
//		assert(ShotInfo.ShotIndex == NewShot);
		/*assert(ShotInfo.ShotIndex != -1);
		assert(ShotInfo.Time == CurrentTime);
		ShotInfosCheck[NewShot-PlayerShotMinIndex] = ShotInfo;*/
#endif

		Objects[NewShot] = Objects[PlayerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShipDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
#ifndef USER_CONTROL
		/*assert(ShotInfo.StartX == Objects[NewShot].PositionX);
		assert(ShotInfo.StartY == Objects[NewShot].PositionY);
		assert(ShotInfo.VelocityX == Objects[NewShot].VelocityX);
		assert(ShotInfo.VelocityY == Objects[NewShot].VelocityY);*/
#endif
	}

	static void ShootLocationFromAngle(byte Direction, word& PositionX, word& PositionY, char& VelocityX, char& VelocityY)
	{
		//xVelocity
		byte a = Direction;
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += byte(VelocityX);
		Clamp(a, 0x91, 0x6F);
		VelocityX = char(a);

		//yVelocity
		a = Direction;
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += byte(VelocityY);
		Clamp(a, 0x91, 0x6F);
		VelocityY = char(a);

		PositionX += char(tmp9) + char(Half(tmp9));
		PositionY += char(tmpC) + char(Half(tmpC));

/*		//xVelocity
		byte a = Var(RAM_ShipDirection);
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += VarO(RAMO_VelocityX, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityX, PlayerIndex+NewShot) = a;

		//yVelocity
		a = Var(RAM_ShipDirection);
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += VarO(RAMO_VelocityY, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityY, PlayerIndex+NewShot) = a;

		//xPosition
		a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, VarO(RAMO_PositionExactX, PlayerIndex), c);
		VarO(RAMO_PositionExactX, PlayerIndex+NewShot) = a;
		Add(tmp8, VarO(RAMO_PositionX, PlayerIndex), c);
		VarO(RAMO_PositionX, PlayerIndex+NewShot) = tmp8;

		//yPosition
		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, VarO(RAMO_PositionExactY, PlayerIndex), c);
		VarO(RAMO_PositionExactY, PlayerIndex+NewShot) = a;
		Add(tmpB, VarO(RAMO_PositionY, PlayerIndex), c);
		VarO(RAMO_PositionY, PlayerIndex+NewShot) = tmpB;*/
		//xPosition
		/*a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, LowByte(PositionX), c);
		LowByte(PositionX) = a;
		Add(tmp8, HighByte(PositionX), c);
		HighByte(PositionX) = tmp8;*/

		//yPosition
/*		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, LowByte(PositionY), c);
		LowByte(PositionY) = a;
		Add(tmpB, HighByte(PositionY), c);
		HighByte(PositionY) = tmpB;*/
	}

	void DoHyperSpace(const KeysPacket& keys)//sub_6E74
	{
		if(!(keys.keys & KeysPacket::KEY_HYPERSPACE) ||
			NumPlayers == 0 ||
			InvisibleTimer ||
			Objects[PlayerIndex].Status < 0)
			return;

		Objects[PlayerIndex].Status = 0;
		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;
		InvisibleTimer = 0x30;

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionX) = a;
	
		Rand(); Rand(); Rand(); Rand();

		a = Rand() & 0x1F;
		HyperSpaceStatus = 1;
		if(a >= 0x18)
		{
			a &= 7;
			bool c = true;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= NumAsteroids)//HyperSpace fehlgeschlagen
				HyperSpaceStatus = -128;
		}
		if(a > 0x14)
			a = 0x14;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionY) = a;
	}

	void UpdateHyperspace(const KeysPacket& keys)//sub_703F
	{
		if(NumPlayers == 0 ||
			Objects[PlayerIndex].Status < 0)
			return;
		if(InvisibleTimer == 0)
		{
			UpdateDirectionAndThrust(keys);
			return;
		}
		if(--InvisibleTimer)
			return;
		if(char(HyperSpaceStatus) < 0) goto loc_706F;
		if(HyperSpaceStatus) goto loc_7068;
		if(!CanShipAppear()) goto loc_7081;
		if(Objects[SaucerIndex].Status)
		{
			InvisibleTimer = 2;
			return;
		}
loc_7068:
		Objects[PlayerIndex].Status = 1;
		goto loc_7081;
loc_706F:
		Objects[PlayerIndex].Status = -96;
		NumShips--;
		InvisibleTimer = 0x81;
loc_7081:
		HyperSpaceStatus = 0;
	}

	bool CanShipAppear()
	{
		for(int i = SaucerIndex; i >= 0; i--)
		{
			if(Objects[i].Status == 0)
				continue;

			byte dif = HighByte(Objects[i].PositionX)-HighByte(Objects[PlayerIndex].PositionX);
			if(dif < 0xFC && dif >= 4)
				continue;

			dif = HighByte(Objects[i].PositionY)-HighByte(Objects[PlayerIndex].PositionY);
			if(dif < 0xFC && dif >= 4)
				continue;

			InvisibleTimer++;
			return false;
		}
		return true;
	}

	void UpdateDirectionAndThrust(const KeysPacket& keys)//loc_7086
	{
		if(keys.keys & KeysPacket::KEY_LEFT)
			ShipDirection += RotationSpeed;
		else if(keys.keys & KeysPacket::KEY_RIGHT)
			ShipDirection -= RotationSpeed;
		
		if(FastTimer & 1)
			return;
		if(keys.keys & KeysPacket::KEY_THRUST)
		{
			byte y = 0;
			byte a = ShipDirection;//a=0
			CosLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;   //a=80/FE
			bool c = false;
			Add(a, AccX, c);//a=f9  c=1
			byte x = a;//x=77
			a = y;
			Add(a, Objects[PlayerIndex].VelocityX, c);//a=2
			sub7125(a, x);
			Objects[PlayerIndex].VelocityX = a;
			AccX = x;

			y = 0;
			a = ShipDirection;
			SinLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;
			c = false;
			Add(a, AccY, c);
			x = a;
			a = y;
			Add(a, Objects[PlayerIndex].VelocityY, c);
			sub7125(a, x);
			Objects[PlayerIndex].VelocityY = a;
			AccY = x;
		}
		else
		{
			// KEY_THRUST nicht gedrckt:
			if(Objects[PlayerIndex].VelocityX | AccX)
			{
				byte a = (Objects[PlayerIndex].VelocityX << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccX, c); // Wenn man beide Zeilen durch Add(AccX, a, c); ersetzt optimiert der Microsoft Compiler falsch...
				AccX = a;
				Add((byte&)Objects[PlayerIndex].VelocityX, x, c);
			}
			if(Objects[PlayerIndex].VelocityY | AccY)
			{
				byte a = (Objects[PlayerIndex].VelocityY << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccY, c);
				AccY = a;
				Add((byte&)Objects[PlayerIndex].VelocityY, x, c);
			}
/*		
				char a = Var(RAM_VelocityY)<<1;
				char x = 0xFF;
				a ^= 0xFF;
				bool c = false;
				if(a >= 0)
				{
					x++;
					c = true;
				}
				int sum = int(a)+int(Var(RAM_AccY))+c;
				bool overflow = (sum & 0xFF00) != 0;
				a = sum;
				Var(RAM_AccY) = a;
				a = x;
				a += Var(RAM_VelocityY) + overflow;
				Var(RAM_VelocityY) = a;*/
		}
	}


	void PreMoveObject(int i)
	{
		//byte tmp4, tmp5, tmp6, tmp7;
		byte a = Objects[i].Status;
		if(a == 0)
			return;
		//loc_6F62
		if(char(a) < 0)
		{
			//Objekt explodiert
			a = ((a^0xFF)+1) >> 4;
//			a = (-a) >> 4;
			bool c = true;
			if(i == PlayerIndex)
			{
				c = (FastTimer&1) != 0;
				a = 0;
			}
			//loc_6F77
			Add(a, Objects[i].Status, c);
			if(char(a) < 0)
			{//loc_6FA1
				//Objekt explodiert weiter
				Objects[i].Status = a;
				//a = (a&0xF0)+0x10;
				//if(i == PlayerIndex)
				//	a = 0;
				//byte y = a;
				//4567a = VarO(RAMO_PositionExactX, i);
				{//loc_7027
					//sub_72FE
				}
			}
			else if(i == PlayerIndex)
			{//loc_6F93
				ResetPlayerPosition();
				Objects[i].Status = 0;
			}
			else if(i == SaucerIndex)
			{//loc_6F99
				SaucerCountdown = SaucerCountdownStart;
				Objects[i].Status = 0;
			}
			else
			{
				assert(i >= AsteroidMinIndex && i <= AsteroidMaxIndex);
				if(--NumAsteroids == 0)
					NewLevelStartCountdown = 0x7F;
				Objects[i].Status = 0;
			}
			return;
		}
		//loc_6FC7
//		byte y = 0;

		//xPosition += char(VarO(RAMO_VelocityX, i));
		/*a = VarO(RAMO_VelocityX, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactX, i), c);
		VarO(RAMO_PositionExactX, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionX, i), c);*/
//		if(a >= 0x20)//Objekt geht rechts raus

		if(i == SaucerIndex && word(Objects[i].PositionX + Objects[i].VelocityX) >= 0x2000)
		{
			//Das UFO ist ber den Bildschirmrand gelaufen
			//sub_702D
			SaucerCountdown = SaucerCountdownStart;
			Objects[SaucerIndex].Status = 0;
			LowByte(Objects[SaucerIndex].PositionX) = word(Objects[i].PositionX + Objects[i].VelocityX) & 0xFF;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
			return;
		}
		//Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
//		MakeBytesFromWord(xPosition, VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//loc_6FEC
		//VarO(RAMO_PositionX, i) = a;

		//Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
		Objects[i].MoveLinear(1);
//		MakeBytesFromWord(yPosition, VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));

/*		y = 0;
		a = VarO(RAMO_VelocityY, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactY, i), c);
		VarO(RAMO_PositionExactY, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionY, i), c);
		if(a >= 0x18)
		{
			if(a == 0x18)
			{//loc_7011
				a = 0;
			}
			else
				a = 0x17;
		}
		//loc_7013
		VarO(RAMO_PositionY, i) = a;*/

		/*a = Objects[i].Status;
		y = 0xE0;
		if((a&1) == 0)
		{
			y = 0xF0;
			if((a&2) == 0)
				y = 0;
		}*/
		//sub_72FE(i);
	}

	void PostMoveObject(int i)//sub_72FE
	{
	/*	byte tmp0 = y;
		bool c = false;
		a = tmp5;
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		tmp5 = a;

		a = tmp7+4;
		c = false;
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		tmp7 = a;
		byte x = 4;
		//sub_7C1C
		a = 0x70;
		a -= tmp0;
		while(char(a) >= -96)
		{
			byte stack = a;
			a = 0x90;
			//sub_7CDE
			a = stack;
			a -= 0x10;
		}
		//loc_733B
		//sub_7CDE
		a = Objects[i].Status;
		if(char(a) >= 0)
		{//loc_735B
		}
		if(i != PlayerIndex)
		{
			y = (a&0x0C)>>1;
//				a = 50F8[y];
//				x = 50F9[y];
			if(x != 0)
			{
				//loc_7370
			}
		}
		{//sub_7465
			
		}*/
//loc_7384:
		//...
		if(Objects[i].Status > 0 && i > SaucerIndex && (FastTimer & 3) == 0)
		{
			Objects[i].Status--;
			if(!updating && !Objects[i].Status && i >= PlayerShotMinIndex)
			{//////////
#ifdef PRINT_DEBUG_INFO
				printf("Shot %i ins Leere gegangen um %i\n", i-PlayerShotMinIndex, CurrentTime);
#endif
				//*pErrorsOccured = true;
			}
		}
	}

	void ResetAsteroids();


	void ResetPlayerPosition()//sub_71E8
	{
		Objects[PlayerIndex].PositionX = 0x1060;
		Objects[PlayerIndex].PositionY = 0x0C60;

		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;

		Objects[PlayerIndex].SetFixed();
	}

	static void CosLookup(byte& a)//sub_77D2
	{
		a += 0x40;
		SinLookup(a);
	}

	static void SinLookup(byte& a)//sub_77D5
	{
		const byte Table[0x41] =//0x57B9
		{
			0x00, 0x03, 0x06, 0x09, 0x0c, 0x10, 0x13, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28,
			0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 0x44, 0x47, 0x49, 0x4c, 0x4e,
			0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6b,
			0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f
		};
		bool inv = false;
		if(char(a) < 0)
		{
			inv = true;
			a &= 0x7F;
		}
		if(a >= 0x41)
			a = (a^0x7F) + 1;
		a = Table[a];
		if(inv)
			a = (a^0xFF) + 1;
	}

	void sub7125(byte& a, byte& x)
	{
		if(char(a) >= 0)
		{
			if(a >= 0x40)
			{
				x = 0xFF;
				a = 0x3F;
			}
		}
		else
		{
			if(a < 0xC0)
			{
				x = 1;
				a = 0xC0;
			}
		}
	}

	/*void CloneAsteroid(byte Dest, byte Src)//sub_6A9D
	{
		Objects[Dest] = Objects[Src];
		Objects[Dest].Status = (Objects[Src].Status&7) | (Rand()&0x18);
	}*/

	//Erzeugt zwei kleine Asteroiden
	void SplitAsteroid(byte CollisionCauser, byte Asteroid, DecisionList& Decisions)//sub_75EC
	{
		_2F9 = 0x50;
		//byte a = Objects[y].Status;
		//a &= 0x78;
		//byte tmp_e = a;
		byte NewStatus = (Objects[Asteroid].Status&7) >> 1;
		if(NumPlayers && (CollisionCauser == PlayerIndex || CollisionCauser >= PlayerShotMinIndex))
		{
			//Der Schuss ist vom Spieler oder der Spieler kollidiert selber mit dem Asteroid -> Punkte
			if(NewStatus == 0)
				AddScore(10);
			else if(NewStatus == 1)
				AddScore(5);
			else if(NewStatus == 2)
				AddScore(2);
			else
				assert(0);
		}
		if(NewStatus)
			Objects[Asteroid].Status = (NewStatus | (Objects[Asteroid].Status&0x78));
		else
		{
			//Objects[Asteroid].Status = 0;
			return;
		}
		CreateSmallAsteroid(Asteroid, true, Decisions);
		CreateSmallAsteroid(Asteroid, false, Decisions);
/*		byte NewAsteroid = NextAsteroidSlot(PlayerIndex-1);
		if(NewAsteroid == 0xFF)
		{//////////
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Keine Slots mehr uebrig!!\n");
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionX) ^= (Objects[NewAsteroid].VelocityX&0x1F) << 1;
		NewAsteroid = NextAsteroidSlot(NewAsteroid-1);
		if(NewAsteroid == 0xFF)
		{
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Nur noch ein Slot uebrig bei Asteroid %x um %i!!\n", Asteroid, CurrentTime);
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionY) ^= (Objects[NewAsteroid].VelocityY&0x1F) << 1;*/
	}
	void CreateSmallAsteroid(int BaseAsteroid, bool Type, DecisionList& Decisions)
	{
		//sub_745A
		int NewAsteroid = AsteroidMaxIndex;
		while(Objects[NewAsteroid].Status)
			if(NewAsteroid-- == AsteroidMinIndex)
			{
#ifdef PRINT_DEBUG_INFO
				printf("Keine Slots mehr fuer neuen Asteroiden uebrig!!\n");
#endif
				return;
			}
		NumAsteroids++;

		//sub_6A9D
		Objects[NewAsteroid] = Objects[BaseAsteroid];
		Objects[NewAsteroid].Status = (Objects[BaseAsteroid].Status&7) | (Rand()&0x18);

		//sub_7203
		byte a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cAltX; i++)
		{
			Objects[NewAsteroid].AltVX[i] = a + Objects[BaseAsteroid].AltVX[i];
			sub_7233(Objects[NewAsteroid].AltVX[i]);
		}

		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cAltY; i++)
		{
			Objects[NewAsteroid].AltVY[i] = a + Objects[BaseAsteroid].AltVY[i];
			sub_7233(Objects[NewAsteroid].AltVY[i]);
		}

		if(Type)
			for(int i = 0; i < Objects[NewAsteroid].cAltX; i++)
				LowByte(Objects[NewAsteroid].AltPX[i]) ^= (Objects[NewAsteroid].AltVX[i] & 0x1F) << 1;
		else
			for(int i = 0; i < Objects[NewAsteroid].cAltY; i++)
				LowByte(Objects[NewAsteroid].AltPY[i]) ^= (Objects[NewAsteroid].AltVY[i] & 0x1F) << 1;
		Objects[NewAsteroid].RemoveEqualities();

		RandMakesDifference(Decisions);
	}

	/*byte NextAsteroidSlot(byte StartSearchAt)
	{//sub_745A
		byte i = StartSearchAt;
		while(i!=0xFF && Objects[i].Status)
			i--;
		return i;
	}*/

	void sub_7203(byte& x, byte& y)
	{
		char a = Rand() & 0x8F;
		if(a < 0)
			a |= 0xF0;
		a += Objects[y].VelocityX;
		sub_7233(a);
		Objects[x].VelocityX = a;
	
		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(a < 0)
			a |= 0xF0;
		a += Objects[y].VelocityY;
		sub_7233(a);
		Objects[x].VelocityY = a;
	}

	void sub_7233(char& a)
	{
		if(a < 0)
		{
			if(a < -31)
				a = -31;
			else if(a > -6)
				a = -6;
		}
		else
		{
			if(a < 6)
				a = 6;
			else if(a > 31)
				a = 31;
		}
	}

	void AddScore(byte ToAdd)
	{//sub_7397
		word Score = DecimalToBin(PlayerScoreThousends, PlayerScoreTens);
		if(Score/1000 != (Score+ToAdd)/1000)
			NumShips++;
		Score += ToAdd;
		if(pScore)
			*pScore += ToAdd;
		BinToDecimal(Score, PlayerScoreThousends, PlayerScoreTens);
	}
	void CheckCollisions(byte CollisionCauser, DecisionList& Decisions);

	static bool AreObjectsNear(byte i, word iPositionX, word iPositionY, byte iStatus,
							   byte j, word jPositionX, word jPositionY, byte jStatus)
	{//Ship/Saucer/Shots mssen in i sein, Asteroiden in j
		byte a = LowByte(jPositionX);
		bool c = true;
		Subtract(a, LowByte(iPositionX), c);
		byte tmp8 = a;
		a = HighByte(jPositionX);
		Subtract(a, HighByte(iPositionX), c);
		ShiftRight(a, c);
		RotateRight(tmp8, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp8 ^= 0xFF;
		}
		a = LowByte(jPositionY);
		c = true;
		Subtract(a, LowByte(iPositionY), c);
		byte tmp9 = a;
		a = HighByte(jPositionY);
		Subtract(a, HighByte(iPositionY), c);
		ShiftRight(a, c);
		RotateRight(tmp9, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp9 ^= 0xFF;
		}
		a = 0x2A;
		ShiftRight(jStatus, c);
		if(!c)
		{
			a = 0x48;
			ShiftRight(jStatus, c);
			if(!c)
				a = 0x84;
		}
		if(i == PlayerIndex)
			a += 0x1C;
		else if(i == SaucerIndex)
		{
			c = true;
			Add(a, 0x12, c);
			if(iStatus != 1)
				Add(a, 0x12, c);
		}
		if(a < tmp8) return false;
		if(a < tmp9) return false;
		byte tmp = a;
		a >>= 1;
		c = false;
		Add(a, tmp, c);
		tmp = a;
		a = tmp9;
		Add(a, tmp8, c);
		if(c) return false;
		if(a >= tmp) return false;
		return true;
	}

	// Gibt zurck, ob sich die Asteroiden oder das UFO gendert haben
	bool OnCollision(byte CollisionCauser, byte& y, DecisionList& Decisions)//sub_6B0F
	{
		if(CollisionCauser != SaucerIndex)
		{
			if(CollisionCauser != PlayerIndex)
			{
				// CollisionCauser ist ein Schuss
				Objects[CollisionCauser].Status = 0; //Schuss lschen
				if(y == PlayerIndex)
				{
					NumShips--;
					InvisibleTimer = 0x81;
				}
				else if(y > PlayerIndex)
					DestroySaucer();
				else
					SplitAsteroid(CollisionCauser, y, Decisions);
				Objects[y].Status = -96;
				Objects[y].SetVelocity(0, 0);
				return y != PlayerIndex;
			}
			InvisibleTimer = 0x81;
			NumShips--;
			CollisionCauser = PlayerIndex;
		}
		else if(y == PlayerIndex)
		{
			CollisionCauser = PlayerIndex;
			y = SaucerIndex;
			InvisibleTimer = 0x81;
			NumShips--;
		}
		Objects[CollisionCauser].Status = -96;
		Objects[CollisionCauser].SetVelocity(0, 0);
		if(y < PlayerIndex)
		{
			SplitAsteroid(CollisionCauser, y, Decisions);
		}
		else
		{
			assert(y == SaucerIndex);
			DestroySaucer();
		}
		Objects[y].Status = -96;
		Objects[y].SetVelocity(0, 0);
		return true;
	}

	void RandMakesDifference(DecisionList& Decisions)
	{
		if(!RandomSeedKnown && Decisions.RandomSeed == -1)
			Decisions.RandomSeed = NumSeedCombinations-1;
#ifdef PRINT_DECISIONS
		if(!RandomSeedKnown)
			printf("Entscheide fuer Randomseed #%i s1 %x s2 %x\n", Decisions.RandomSeed, RandomSeed1, RandomSeed2);
#endif
		RandomSeedKnown = true;
	}

	void NeedTimerBits(int BitsNeeded, DecisionList& Decisions)
	{
		if(BitsNeeded <= TimerBitsKnown)
			return;
		if(Decisions.Timer == -1)
			Decisions.Timer = (1 << (BitsNeeded-TimerBitsKnown)) - 1;
		FastTimer = (Decisions.Timer << TimerBitsKnown) | (FastTimer & ~(0xFF<<TimerBitsKnown));
		TimerBitsKnown = BitsNeeded;
		printf("%i Timerbits\n", TimerBitsKnown);
	}

	void UpdateSaucer(DecisionList& Decisions)//sub_6B93
	{
		if(FastTimer & 3 || Objects[SaucerIndex].Status < 0)
			return;
		
		if(Objects[SaucerIndex].Status == 0)
		{
			if(NumPlayers && Objects[PlayerIndex].Status <= 0)
				return;
			if(_2F9)
				_2F9--;
			if(--SaucerCountdown)
				return;
			SaucerCountdown = 0x12;
			if(_2F9 && (NumAsteroids == 0 || NumAsteroids >= _2FD))
				return;

			//Saucer erstellen
			if(SaucerCountdownStart >= 38)
				SaucerCountdownStart -= 6;
			byte a = Rand();
			if(!SaucerPositionBitKnown)
			{
				if(Decisions.SaucerPositionBit == -1)
					Decisions.SaucerPositionBit = 31;
				Objects[SaucerIndex].PositionY = Decisions.SaucerPositionBit << 3;
#ifdef PRINT_DECISIONS
				printf("Entscheide bei Saucer fuer %i\n", Decisions.SaucerPositionBit);
#endif
				SaucerPositionBitKnown = true;
			}
			bool c;
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			if(a >= 0x18)
				a &= 0x17;
			HighByte(Objects[SaucerIndex].PositionY) = a;
			Objects[SaucerIndex].PositionX = RandomSeed2 & 0x40 ? 0 : 0x1FFF;
			Objects[SaucerIndex].VelocityX = RandomSeed2 & 0x40 ? 16 : -16;
			Objects[SaucerIndex].Status = 2;
			Objects[SaucerIndex].cAltX = Objects[SaucerIndex].cAltY = 1;
			if(char(SaucerCountdownStart) >= 0 && (PlayerScoreThousends >= 0x30 || (SaucerCountdownStart>>1) <  Rand()))
				Objects[SaucerIndex].Status = 1;
			Objects[SaucerIndex].SetFixed();
			RandMakesDifference(Decisions);
			return;
		}

		//Saucer lebt:

		if(TimerBitsKnown < 7 && byte((FastTimer & ~(0xFF<<TimerBitsKnown)) << 1) == 0)
			NeedTimerBits(7, Decisions);
		if(byte(FastTimer << 1) == 0)//Richtung hin und wieder ndern
		{
			const char DirectionTable[] = {-16, 0, 0, 16};
			Objects[SaucerIndex].VelocityY = DirectionTable[Rand()&3];
			RandMakesDifference(Decisions);
		}
		if(NumPlayers && InvisibleTimer)
			return;
		if(--SaucerCountdown)
			return;
		//Wir feuern mal einen Schuss
		SaucerCountdown = 0x0A;

		byte ShotDirection;
		if(Objects[SaucerIndex].Status != 2)
		{
			byte a = Objects[SaucerIndex].VelocityX;
			bool c = a >= 0x80;
			RotateRight(a, c);
			byte tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionX);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionX), c);
			byte tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionX);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionX), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte x = a;

			a = Objects[SaucerIndex].VelocityY;
			c = a >= 0x80;
			RotateRight(a, c);
			tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionY);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionY), c);
			tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionY);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionY), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte y = a;

			ShotDirection = loc_76F0(x, y);

			a = Rand();
			c = PlayerScoreThousends >= 0x35;
			a &= c ? 0x87 : 0x8F;
			if(char(a) < 0)
				a |= c ? 0x78 : 0x70;
			Add(ShotDirection, a, c);
		}
		else
			ShotDirection = Rand();

		int NewShot = SaucerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == SaucerShotMinIndex)
				return;

		RandMakesDifference(Decisions);

		assert(Objects[SaucerIndex].IsFixed());
		Objects[NewShot] = Objects[SaucerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShotDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
	}

	byte loc_76F0(byte x, byte y)
	{
		byte a = y;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = loc_76FC(a, x);
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return loc_76FC(a, x);
	}
	byte loc_76FC(byte a, byte x)
	{
		byte y = a;
		a = x;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = sub_770E(a, y);
			a ^= 0x80;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_770E(a, y);
	}
	byte sub_770E(byte a, byte y)
	{
		byte tmpC = a;
		a = y;	
		if(a == tmpC)
			return 0x20;
		if(a >= tmpC)
		{
			y = tmpC;
			tmpC = a;
			a = y;
			a = sub_7728(a, tmpC, true);
			a -= 0x40;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_7728(a, tmpC, false);
	}
	byte sub_7728(byte a, byte tmpC, bool c)
	{
		byte tmpB = 0;
		for(int i = 0; i < 4; i++)
		{
			RotateLeft(tmpB, c);
			RotateLeft(a, c);
			c = a >= tmpC;
			if(c)
				Subtract(a, tmpC, c);
		}
		RotateLeft(tmpB, c);

		const byte _772F[0x10] = {0x00, 0x02, 0x05, 0x07, 0x0A, 0x0C, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1A, 0x1C, 0x1D, 0x1F};
		return _772F[tmpB & 0x0F];
	}

	void DestroySaucer()//loc_6B73
	{
		SaucerCountdown = SaucerCountdownStart;
		if(NumPlayers)
		{
			if(Objects[SaucerIndex].Status == 1)
				AddScore(100);
			else
				AddScore(20);
		}
	}

	byte Rand()
	{
		bool carry = false;
		ShiftLeft(RandomSeed1, carry);
		if(char(RotateLeft(RandomSeed2, carry)) < 0)
			RandomSeed1++;
		if(RandomSeed1 & 2)
			RandomSeed1 ^= 1;
		if(RandomSeed1 == 0 && RandomSeed2 == 0)
			RandomSeed1++;
		return RandomSeed1;
	}
};

struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-byte zurck
	byte ram[0x300];
};

#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
